/**
  Copyright (c) 2010 Freescale Semiconductor
  Freescale Confidential Proprietary
  
  \file  	  DMAHandler.h
  \brief	  This is the DMA Handler Library Driver header File
  \brief	  Library for Controlling the DMA blit operations
  \brief	  Combines DCU and DMA drivers functionality
  \author	  Freescale Semiconductor
  \author	  MSG
  \author	  IM, b06623
  \version	  2.0
  \revision	  $Revision: 247 $
  \date  	  $Date: 2011-09-22 17:48:24 -0500 (Thu, 22 Sep 2011) $  

* History:  18/March/2008 - Initial Version
*   		12/May/2009 - MISRA Check, Release

* Copyright (c) 2010, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
  
*/


#ifndef 	_DMAHANDLER_H_
#define  	_DMAHANDLER_H_	 

#include	 "..\HAL\DCU_drv.h"
#include	 "..\HAL\DMA_drv.h"
#include	 "..\HAL\GALLO.h"

/******************** Font Library Driver Data Types  ************************/

typedef  enum
{
    DMAHR_ERROR_OK,
    DMAHR_ERROR_FAIL
}DMAHR_Error_t;

typedef void (*DMAHR_Callback_t)(void);

#define DMAHR_NOCHNL	(0xFFu)	

/*********************** Configuration Parameters ****************************/

#define DMAHR_START_CH	(0)
#define DMAHR_END_CH	(1)

/************************ Public Functions **********************************/

void	DMAHR_Init(void);
void	DMAHR_ScheduleDefrag(DMAHR_Callback_t cb);
uint8_t DMAHR_GetNextFreeChannel(void);
void	DMAHR_Suspend(void);
void	DMAHR_Resume(void);

/************************** Public MACROS ************************************/
                                          
#define		DMAHR_CancelDefrag()	DMAHR_DF_Flag = 0u

/************************ Private Functions **********************************/

extern uint8_t DMAHR_DF_Flag;

#endif /* #define _DMAHANDLER_H_ */ 
